<?php
class Ybc_megamenu_cache_class { 
	private $expire = 3600; 

	public function get($key) {
		$files = glob(dirname(__FILE__).'/../cache/' . 'cache.' . preg_replace('/[^A-Z0-9\._-]/i', '', $key) . '.*');
        
		if ($files) {
			$cache = Tools::file_get_contents($files[0]);
			
			$data = @unserialize($cache);
			
			foreach ($files as $file) {
				$time = Tools::substr(strrchr($file, '.'), 1);

      			if ($time < time()) {
					if (file_exists($file)) {
						@unlink($file);
					}
      			}
    		}
			
			return $data;			
		}
        return false;
	}

  	public function set($key, $value) {
    	$this->delete($key);
		
		$file = dirname(__FILE__).'/../cache/'  . 'cache.' . preg_replace('/[^A-Z0-9\._-]/i', '', $key) . '.' . (time() + $this->expire);
    	
		$handle = fopen($file, 'w');
        $data = @serialize($value);
    	fwrite($handle, $data ? $data : serialize(array()));
		
    	fclose($handle);
  	}
	
  	public function delete($key) {
		$files = glob(dirname(__FILE__).'/../cache/'  . 'cache.' . preg_replace('/[^A-Z0-9\._-]/i', '', $key) . '.*');
		
		if ($files) {
    		foreach ($files as $file) {
      			if (file_exists($file)) {
					unlink($file);
				}
    		}
		}
  	}
}
?>