(function() {
  var callbackProperties, decorateElementClass, decorateElementPrototype;

  if (window.__CUSTOM_HTML_ELEMENTS_CLASSES__ == null) {
    window.__CUSTOM_HTML_ELEMENTS_CLASSES__ = {};
  }

  callbackProperties = ['createdCallback', 'attachedCallback', 'detachedCallback', 'attributeChangedCallback'];

  decorateElementPrototype = function(target, source) {
    callbackProperties.forEach(function(k) {
      return Object.defineProperty(target, k, {
        value: function() {
          var _ref;
          return (_ref = this["__" + k]) != null ? _ref.apply(this, arguments) : void 0;
        },
        writable: true,
        enumerable: true,
        configurable: true
      });
    });
    return Object.getOwnPropertyNames(source).forEach(function(k) {
      var descriptor;
      if (k === 'constructor') {
        return;
      }
      descriptor = Object.getOwnPropertyDescriptor(source, k);
      if (callbackProperties.indexOf(k) > -1) {
        return Object.defineProperty(target, "__" + k, descriptor);
      } else {
        return Object.defineProperty(target, k, descriptor);
      }
    });
  };

  decorateElementClass = function(target, source) {
    return Object.getOwnPropertyNames(source).forEach(function(k) {
      var descriptor;
      if (k === 'length' || k === 'name' || k === 'arguments' || k === 'caller' || k === 'prototype') {
        return;
      }
      descriptor = Object.getOwnPropertyDescriptor(source, k);
      return Object.defineProperty(target, k, descriptor);
    });
  };

  module.exports = function(nodeName, options) {
    var elementClass, elementPrototype, klass, proto;
    klass = options["class"];
    if (klass != null) {
      proto = klass.prototype;
    } else {
      proto = options;
    }
    if (__CUSTOM_HTML_ELEMENTS_CLASSES__[nodeName]) {
      elementClass = __CUSTOM_HTML_ELEMENTS_CLASSES__[nodeName];
      decorateElementPrototype(elementClass.prototype, proto);
      if (klass != null) {
        decorateElementClass(elementClass, klass);
      }
      return elementClass;
    } else {
      elementPrototype = Object.create(HTMLElement.prototype);
      decorateElementPrototype(elementPrototype, proto);
      elementClass = document.registerElement(nodeName, {
        prototype: Object.create(elementPrototype)
      });
      if (klass != null) {
        decorateElementClass(elementClass, klass);
      }
      return __CUSTOM_HTML_ELEMENTS_CLASSES__[nodeName] = elementClass;
    }
  };

}).call(this);
