(function() {
  var BabelSpacePenDSL, Builder, Events, Mixin, SelfClosingTags, SpacePenDSL, Tags, Template, _ref, _ref1,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  Mixin = require('mixto');

  Tags = 'a abbr address article aside audio b bdi bdo blockquote body button canvas\
   caption cite code colgroup datalist dd del details dfn dialog div dl dt em\
   fieldset figcaption figure footer form h1 h2 h3 h4 h5 h6 head header html i\
   iframe ins kbd label legend li main map mark menu meter nav noscript object\
   ol optgroup option output p pre progress q rp rt ruby s samp script section\
   select small span strong style sub summary sup table tbody td textarea tfoot\
   th thead time title tr u ul var video area base br col command embed hr img\
   input keygen link meta param source track wbr'.split(/\s+/);

  SelfClosingTags = {};

  'area base br col command embed hr img input keygen link meta param\
 source track wbr'.split(/\s+/).forEach(function(tag) {
    return SelfClosingTags[tag] = true;
  });

  Events = 'blur change click dblclick error focus input keydown\
   keypress keyup load mousedown mousemove mouseout mouseover\
   mouseup resize scroll select submit unload'.split(/\s+/);

  BabelSpacePenDSL = (function(_super) {
    __extends(BabelSpacePenDSL, _super);

    function BabelSpacePenDSL() {
      _ref = BabelSpacePenDSL.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    BabelSpacePenDSL.prototype.buildContent = function() {
      if (this.constructor.content != null) {
        return SpacePenDSL.buildContent(this, this.constructor.content);
      }
    };

    return BabelSpacePenDSL;

  })(Mixin);

  module.exports = SpacePenDSL = (function(_super) {
    __extends(SpacePenDSL, _super);

    function SpacePenDSL() {
      _ref1 = SpacePenDSL.__super__.constructor.apply(this, arguments);
      return _ref1;
    }

    SpacePenDSL.Babel = BabelSpacePenDSL;

    SpacePenDSL.includeInto = function(klass) {
      SpacePenDSL.__super__.constructor.includeInto.call(this, klass);
      Object.defineProperty(klass, 'content', {
        enumerable: false,
        get: function() {
          return this.prototype.__content__;
        },
        set: function(value) {
          return this.prototype.__content__ = value;
        }
      });
      Object.defineProperty(klass.prototype, 'createdCallback', {
        enumerable: true,
        get: function() {
          return this.__create__;
        },
        set: function(value) {
          return this.__createdCallback__ = value;
        }
      });
      Object.defineProperty(klass.prototype, '__create__', {
        enumerable: true,
        value: function() {
          if (this.__content__ != null) {
            SpacePenDSL.buildContent(this, this.__content__);
          }
          if (this.__createdCallback__ != null) {
            return this.__createdCallback__();
          }
        }
      });
      return klass.useShadowRoot = function() {
        return klass.prototype.__useShadowRoot__ = true;
      };
    };

    SpacePenDSL.buildContent = function(element, content) {
      var html, root, template;
      template = new Template;
      content.call(template);
      html = template.buildHtml()[0];
      root = element.__useShadowRoot__ ? root = element.shadowRoot = element.createShadowRoot() : root = element;
      root.innerHTML = html;
      return this.wireOutlets(element, root);
    };

    SpacePenDSL.wireOutlets = function(view, root) {
      var element, outlet, _i, _len, _ref2;
      _ref2 = root.querySelectorAll('[outlet]');
      for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
        element = _ref2[_i];
        outlet = element.getAttribute('outlet');
        view[outlet] = element;
        element.removeAttribute('outlet');
      }
      return void 0;
    };

    return SpacePenDSL;

  })(Mixin);

  Template = (function() {
    function Template() {
      this.currentBuilder = new Builder;
    }

    Tags.forEach(function(tagName) {
      return Template.prototype[tagName] = function() {
        var args, _ref2;
        args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        return (_ref2 = this.currentBuilder).tag.apply(_ref2, [tagName].concat(__slice.call(args)));
      };
    });

    Template.prototype.subview = function(name, view) {
      return this.currentBuilder.subview(name, view);
    };

    Template.prototype.text = function(string) {
      return this.currentBuilder.text(string);
    };

    Template.prototype.tag = function() {
      var args, tagName, _ref2;
      tagName = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      return (_ref2 = this.currentBuilder).tag.apply(_ref2, [tagName].concat(__slice.call(args)));
    };

    Template.prototype.raw = function(string) {
      return this.currentBuilder.raw(string);
    };

    Template.prototype.buildHtml = function() {
      return this.currentBuilder.buildHtml();
    };

    return Template;

  })();

  Builder = (function() {
    function Builder() {
      this.document = [];
      this.postProcessingSteps = [];
    }

    Builder.prototype.buildHtml = function() {
      return [this.document.join(''), this.postProcessingSteps];
    };

    Builder.prototype.tag = function() {
      var args, name, options;
      name = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      options = this.extractOptions(args);
      this.openTag(name, options.attributes);
      if (SelfClosingTags.hasOwnProperty(name)) {
        if ((options.text != null) || (options.content != null)) {
          throw new Error("Self-closing tag " + name + " cannot have text or content");
        }
      } else {
        if (typeof options.content === "function") {
          options.content();
        }
        if (options.text) {
          this.text(options.text);
        }
        return this.closeTag(name);
      }
    };

    Builder.prototype.openTag = function(name, attributes) {
      var attributeName, attributePairs, attributesString, value;
      if (this.document.length === 0) {
        if (attributes == null) {
          attributes = {};
        }
      }
      attributePairs = (function() {
        var _results;
        _results = [];
        for (attributeName in attributes) {
          value = attributes[attributeName];
          _results.push("" + attributeName + "=\"" + value + "\"");
        }
        return _results;
      })();
      attributesString = attributePairs.length ? " " + attributePairs.join(" ") : "";
      return this.document.push("<" + name + attributesString + ">");
    };

    Builder.prototype.closeTag = function(name) {
      return this.document.push("</" + name + ">");
    };

    Builder.prototype.text = function(string) {
      var escapedString;
      escapedString = string.replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
      return this.document.push(escapedString);
    };

    Builder.prototype.raw = function(string) {
      return this.document.push(string);
    };

    Builder.prototype.subview = function(outletName, subview) {
      var subviewId;
      subviewId = "subview-" + (++idCounter);
      this.tag('div', {
        id: subviewId
      });
      return this.postProcessingSteps.push(function(view) {
        view[outletName] = subview;
        subview.parentView = view;
        return view.find("div#" + subviewId).replaceWith(subview);
      });
    };

    Builder.prototype.extractOptions = function(args) {
      var arg, options, _i, _len;
      options = {};
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        arg = args[_i];
        switch (typeof arg) {
          case 'function':
            options.content = arg;
            break;
          case 'string':
          case 'number':
            options.text = arg.toString();
            break;
          default:
            options.attributes = arg;
        }
      }
      return options;
    };

    return Builder;

  })();

}).call(this);
