(function() {
  var Mixin, ResizeDetection, debounce, deprecate, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Mixin = require('mixto');

  deprecate = require('grim').deprecate;

  debounce = function(func, wait, immediate) {
    var timeout;
    timeout = void 0;
    return function() {
      var args, callNow, context, later;
      context = this;
      args = arguments;
      later = function() {
        timeout = null;
        if (!immediate) {
          return func.apply(context, args);
        }
      };
      callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) {
        return func.apply(context, args);
      }
    };
  };

  module.exports = ResizeDetection = (function(_super) {
    __extends(ResizeDetection, _super);

    function ResizeDetection() {
      _ref = ResizeDetection.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    ResizeDetection.includeInto = function(cls) {
      if (!atom.inSpecMode()) {
        deprecate("ResizeDetection will be removed in future version. Use atom.views.pollDocument instead.");
      }
      return Mixin.includeInto.call(this, cls);
    };

    ResizeDetection.prototype.domPollingInterval = 100;

    ResizeDetection.prototype.domPollingIntervalId = void 0;

    ResizeDetection.prototype.domPollingPaused = false;

    ResizeDetection.prototype.initializeDOMPolling = function() {
      var _this = this;
      this.domPollingIntervalId = setInterval((function() {
        return _this.pollDOM();
      }), this.domPollingInterval);
      this.previousDOMWidth = this.clientWidth;
      return this.previousDOMHeight = this.clientHeight;
    };

    ResizeDetection.prototype.disposeDOMPolling = function() {
      clearInterval(this.domPollingIntervalId);
      return this.domPollingIntervalId = void 0;
    };

    ResizeDetection.prototype.pollDOM = function() {
      if (this.isDOMPollingPrevented()) {
        return;
      }
      if (this.previousDOMWidth !== this.clientWidth || this.previousDOMHeight !== this.clientHeight) {
        this.previousDOMWidth = this.clientWidth;
        this.previousDOMHeight = this.clientHeight;
        return this.resizeDetected(this.previousDOMWidth, this.previousDOMHeight);
      }
    };

    ResizeDetection.prototype.pauseDOMPolling = function() {
      this.domPollingPaused = true;
      if (this.resumeDOMPollingAfterDelay == null) {
        this.resumeDOMPollingAfterDelay = debounce(this.resumeDOMPolling, 100);
      }
      return this.resumeDOMPollingAfterDelay();
    };

    ResizeDetection.prototype.resumeDOMPolling = function() {
      return this.domPollingPaused = false;
    };

    ResizeDetection.prototype.resumeDOMPollingAfterDelay = null;

    ResizeDetection.prototype.isDOMPollingPrevented = function() {
      return this.domPollingPaused;
    };

    ResizeDetection.prototype.resizeDetected = function(width, height) {};

    return ResizeDetection;

  })(Mixin);

}).call(this);
