(function() {
  var CompositeDisposable, Disposable, DisposableEvents, EventsDelegation, Mixin, NO_SELECTOR, eachPair, _ref, _ref1,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Mixin = require('mixto');

  DisposableEvents = require('./disposable-events');

  _ref = require('event-kit'), Disposable = _ref.Disposable, CompositeDisposable = _ref.CompositeDisposable;

  eachPair = function(object, callback) {
    var k, v, _results;
    _results = [];
    for (k in object) {
      v = object[k];
      _results.push(callback(k, v));
    }
    return _results;
  };

  NO_SELECTOR = '__NONE__';

  module.exports = EventsDelegation = (function(_super) {
    __extends(EventsDelegation, _super);

    function EventsDelegation() {
      _ref1 = EventsDelegation.__super__.constructor.apply(this, arguments);
      return _ref1;
    }

    DisposableEvents.includeInto(EventsDelegation);

    EventsDelegation.prototype.subscribeTo = function(object, selector, events) {
      var disposablesForObject, eventsForObject, _ref2, _ref3,
        _this = this;
      if (!(object instanceof HTMLElement)) {
        _ref2 = [this, object, selector], object = _ref2[0], selector = _ref2[1], events = _ref2[2];
      }
      if (typeof selector === 'object') {
        _ref3 = [selector, NO_SELECTOR], events = _ref3[0], selector = _ref3[1];
      }
      if (this.eventsMap == null) {
        this.eventsMap = new WeakMap;
      }
      if (this.disposablesMap == null) {
        this.disposablesMap = new WeakMap;
      }
      if (this.eventsMap.get(object) == null) {
        this.eventsMap.set(object, {});
      }
      if (this.disposablesMap.get(object) == null) {
        this.disposablesMap.set(object, {});
      }
      eventsForObject = this.eventsMap.get(object);
      disposablesForObject = this.disposablesMap.get(object);
      eachPair(events, function(event, callback) {
        if (eventsForObject[event] == null) {
          eventsForObject[event] = {};
          disposablesForObject[event] = _this.createEventListener(object, event);
        }
        return eventsForObject[event][selector] = callback;
      });
      return new Disposable(function() {
        return _this.unsubscribeFrom(object, selector, events);
      });
    };

    EventsDelegation.prototype.unsubscribeFrom = function(object, selector, events) {
      var disposablesForObject, event, eventsForObject, _ref2, _ref3;
      if (!(object instanceof HTMLElement)) {
        _ref2 = [this, object, selector], object = _ref2[0], selector = _ref2[1], events = _ref2[2];
      }
      if (typeof selector === 'object') {
        _ref3 = [selector, NO_SELECTOR], events = _ref3[0], selector = _ref3[1];
      }
      if (!(eventsForObject = this.eventsMap.get(object))) {
        return;
      }
      for (event in events) {
        delete eventsForObject[event][selector];
        if (Object.keys(eventsForObject[event]).length === 0) {
          disposablesForObject = this.disposablesMap.get(object);
          disposablesForObject[event].dispose();
          delete disposablesForObject[event];
          delete eventsForObject[event];
        }
      }
      if (Object.keys(eventsForObject).length === 0) {
        this.eventsMap["delete"](object);
        return this.disposablesMap["delete"](object);
      }
    };

    EventsDelegation.prototype.createEventListener = function(object, event) {
      var listener,
        _this = this;
      listener = function(e) {
        var eventsForObject, target, _ref2;
        if (!(eventsForObject = (_ref2 = _this.eventsMap.get(object)) != null ? _ref2[event] : void 0)) {
          return;
        }
        target = e.target;
        _this.decorateEvent(e);
        _this.eachSelectorFromTarget(e, target, eventsForObject);
        if (!e.isPropagationStopped) {
          if (typeof eventsForObject[NO_SELECTOR] === "function") {
            eventsForObject[NO_SELECTOR](e);
          }
        }
        return true;
      };
      return this.addDisposableEventListener(object, event, listener);
    };

    EventsDelegation.prototype.eachSelectorFromTarget = function(event, target, eventsForObject) {
      var _this = this;
      return this.nodeAndItsAncestors(target, function(node) {
        if (event.isPropagationStopped) {
          return;
        }
        return _this.eachSelector(eventsForObject, function(selector, callback) {
          var matched;
          matched = _this.targetMatch(node, selector);
          if (event.isImmediatePropagationStopped || !matched) {
            return;
          }
          return callback(event);
        });
      });
    };

    EventsDelegation.prototype.eachSelector = function(eventsForObject, callback) {
      var key, keys, _i, _len;
      keys = Object.keys(eventsForObject);
      if (keys.indexOf(NO_SELECTOR) !== -1) {
        keys.splice(keys.indexOf(NO_SELECTOR), 1);
      }
      keys.sort(function(a, b) {
        return b.split(' ').length - a.split(' ').length;
      });
      for (_i = 0, _len = keys.length; _i < _len; _i++) {
        key = keys[_i];
        if (callback(key, eventsForObject[key])) {
          return true;
        }
      }
      return false;
    };

    EventsDelegation.prototype.targetMatch = function(target, selector) {
      var parent;
      if (target.matches(selector)) {
        return true;
      }
      parent = target.parentNode;
      while ((parent != null) && (parent.matches != null)) {
        if (parent.matches(selector)) {
          return true;
        }
        parent = parent.parentNode;
      }
      return false;
    };

    EventsDelegation.prototype.nodeAndItsAncestors = function(node, callback) {
      var parent, _results;
      parent = node.parentNode;
      callback(node);
      _results = [];
      while ((parent != null) && (parent.matches != null)) {
        callback(parent);
        _results.push(parent = parent.parentNode);
      }
      return _results;
    };

    EventsDelegation.prototype.decorateEvent = function(e) {
      var overriddenStop, overriddenStopImmediate;
      overriddenStop = Event.prototype.stopPropagation;
      e.stopPropagation = function() {
        this.isPropagationStopped = true;
        return overriddenStop.apply(this, arguments);
      };
      overriddenStopImmediate = Event.prototype.stopImmediatePropagation;
      return e.stopImmediatePropagation = function() {
        this.isImmediatePropagationStopped = true;
        return overriddenStopImmediate.apply(this, arguments);
      };
    };

    return EventsDelegation;

  })(Mixin);

}).call(this);
