(function() {
  var Ancestors, Mixin, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Mixin = require('mixto');

  module.exports = Ancestors = (function(_super) {
    __extends(Ancestors, _super);

    function Ancestors() {
      _ref = Ancestors.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    /* Public*/


    Ancestors.parents = function(node, selector) {
      var parents;
      if (selector == null) {
        selector = '*';
      }
      parents = [];
      this.eachParent(node, function(parent) {
        if (typeof parent.matches === "function" ? parent.matches(selector) : void 0) {
          return parents.push(parent);
        }
      });
      return parents;
    };

    Ancestors.eachParent = function(node, block) {
      var parent, _results;
      parent = node.parentNode;
      if (parent != null) {
        block(parent);
      }
      _results = [];
      while (parent = parent.parentNode) {
        if (parent != null) {
          _results.push(block(parent));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    Ancestors.prototype.parents = function(selector) {
      if (selector == null) {
        selector = '*';
      }
      return Ancestors.parents(this, selector);
    };

    Ancestors.prototype.queryParentSelectorAll = function(selector) {
      if (selector == null) {
        throw new Error('::queryParentSelectorAll requires a valid selector as argument');
      }
      return this.parents(selector);
    };

    Ancestors.prototype.queryParentSelector = function(selector) {
      if (selector == null) {
        throw new Error('::queryParentSelector requires a valid selector as argument');
      }
      return this.queryParentSelectorAll(selector)[0];
    };

    Ancestors.prototype.eachParent = function(block) {
      return Ancestors.eachParent(this, block);
    };

    return Ancestors;

  })(Mixin);

}).call(this);
