(function() {
  var __slice = [].slice;

  module.exports = {
    requirePackages: function() {
      var packages;
      packages = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return new Promise(function(resolve, reject) {
        var failures, remains, required, solved;
        required = [];
        failures = [];
        remains = packages.length;
        solved = function() {
          remains--;
          if (remains !== 0) {
            return;
          }
          if (failures.length > 0) {
            return reject(failures);
          }
          return resolve(required);
        };
        return packages.forEach(function(pkg, i) {
          var failHandler, promise;
          failHandler = function(reason) {
            failures[i] = reason;
            return solved();
          };
          promise = atom.packages.activatePackage(pkg).then(function(activatedPackage) {
            required[i] = activatedPackage.mainModule;
            return solved();
          });
          if (promise.fail != null) {
            return promise.fail(failHandler);
          } else if (promise["catch"] != null) {
            return promise["catch"](failHandler);
          }
        });
      });
    },
    registerOrUpdateElement: require('./register-or-update-element'),
    Ancestors: require('./mixins/ancestors'),
    AncestorsMethods: require('./mixins/ancestors'),
    DisposableEvents: require('./mixins/disposable-events'),
    EventsDelegation: require('./mixins/events-delegation'),
    ResizeDetection: require('./mixins/resize-detection'),
    SpacePenDSL: require('./mixins/space-pen-dsl')
  };

}).call(this);
