// cd ../../wamp/www/barry_2016/src

var gulp          = require('gulp');
var gulpif        = require('gulp-if');
var concat        = require('gulp-concat');
var sass          = require('gulp-sass');
var autoprefixer  = require('gulp-autoprefixer');
var notify        = require("gulp-notify");
var browserSync   = require('browser-sync');
var reload        = browserSync.reload;
var imagemin      = require('gulp-imagemin');
var argv          = require('yargs').argv;
var iconfont      = require('gulp-iconfont');
var consolidate   = require('gulp-consolidate');
var modernizr     = require('gulp-modernizr');
var sourcemaps    = require('gulp-sourcemaps');
var uglify        = require('gulp-uglify');
var jsmin         = require('gulp-jsmin');
var csso          = require('gulp-csso');

// Check for --production flag
var isProduction = !!(argv.production);

var PATHS = {
 sass: [
   'bower_components/bootstrap-sass/assets/stylesheets/',
   // 'bower_components/fullpage.js',
   'bower_components/owl.carousel/dist/assets/',
   'bower_components/fancybox/source/',
 ],
 javascript: [
   'js/jquery.min.js',
   'bower_components/PACE/pace.min.js',
   'bower_components/bootstrap-sass/assets/javascripts/bootstrap/transition.js',
   'bower_components/bootstrap-sass/assets/javascripts/bootstrap/alert.js',
   'bower_components/parsleyjs/dist/parsley.js',
   'bower_components/waypoints/lib/jquery.waypoints.js',
   'bower_components/fastclick/lib/fastclick.js',
   // 'bower_components/fullpage.js/vendors/jquery.easings.min.js',
   // 'bower_components/fullpage.js/vendors/scrolloverflow.easings.min.js',
   // 'bower_components/fullpage.js/jquery.fullPage.js',
   'node_modules/jquery-mousewheel/jquery.mousewheel.js',
   'bower_components/owl.carousel/dist/owl.carousel.js',
   'bower_components/fancybox/source/jquery.fancybox.js',
   'bower_components/fancybox/source/helpers/jquery.fancybox-thumbs.js',
   'js/scripts.js'
 ]
};

gulp.task('browser-sync', function() {
    var files = [
    './css/styles.css',
    './js/*.js',
    './../**/*.php'
    ];

    browserSync.init(files, {
      // proxy: "http://192.168.1.137/barry_2016/",
      proxy: "http://localhost/barry_2016/",
      notify: false
    });
});

gulp.task('images', function() {
   return gulp.src('./img/**/*')
   .pipe(imagemin({
       verbose: true
   }))
   .pipe(gulp.dest('./../img'))
});

gulp.task('sass', function() {
  return gulp.src('./sass/**/*.scss')
  .pipe(sass({
    includePaths: PATHS.sass
  })
    .on('error', function(error) {
      notify({
        'title': 'Erreur SASS',
        'message': error.formatted.toString()
      }).write(error);
      console.log(error.toString());
      this.emit('end');
    })
  )
  .pipe(csso())
  .pipe(autoprefixer({
    browsers: ['IE 8', 'IE 9','last 5 versions', 'Firefox 14', 'Opera 11.1']
  }))
 .pipe(gulp.dest('./../css/'))
  .pipe(reload({stream:true}));
});

gulp.task('javascript', function() {
 return gulp.src(PATHS.javascript)
   .pipe(sourcemaps.init())
   // .pipe(jsmin())
   .pipe(concat('main.js'))
   .pipe(gulpif(!isProduction, sourcemaps.write()))
   .pipe(gulp.dest('./../js'));
});

gulp.task('iconfont', function () {

 gulp.src('./icons/**/*.svg')

   .pipe(iconfont({
     fontName: 'icons',
     centerHorizontally: true,
     normalize: true,
     prependUnicode: true
   }))

   .on('glyphs', function (glyphs) {

     // Localisation du template SASS
     gulp.src('./sass/templates/_icons.scss')

       .pipe(consolidate('lodash', {
         glyphs: glyphs,
         fontName: 'icons',
         fontPath: '../fonts/',
         className: 'icon'
       }))

       .pipe(gulp.dest('./sass'));
   })

   .pipe(gulp.dest('./../fonts'));
});

gulp.task('modernizr', function() {
  gulp.src('./js/*.js')
    .pipe(modernizr({
        'tests': [
            'touchevents',
            'csstransitions',
            'csstransforms',
            'cssanimations'
        ],
        'options': [
            'mq',
            'setClasses'
        ]
    }))
    .pipe(gulp.dest("../js"))
});

gulp.task('default', ['sass', 'javascript', 'modernizr', 'images', 'iconfont', 'browser-sync'], function() {
  gulp.watch('./sass/**/*.scss', ['sass']);
  gulp.watch('./img/**/*', ['images']);
  gulp.watch('./js/**/*.js', ['javascript']);
  gulp.watch('./icons/**/*.svg', ['iconfont']);
});
