function getParam(param){
    return new URLSearchParams(window.location.search).get(param);
}

if (getParam('utm_medium')) {
    document.getElementById('qrText').style.display = 'block';
}

// Header at scroll for mobile
if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
    document.querySelector('header').classList.add('deactive');
    addEventListener('scroll', (event) => {
        if (window.scrollY >= 250) {
            document.querySelector('header').classList.remove('deactive');
            document.querySelector('header').classList.add('active');
        } else {
            document.querySelector('header').classList.add('deactive');
            document.querySelector('header').classList.remove('active');
        }
    });
} else {
    document.querySelector('header').classList.add('active');
}

/* ------------------ anim ----------------------- */

var h = 0;
if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
    var wh = $(window).height() - 700;
} else {
    var wh = $(window).height() - 200;
}

const data = {
    tab_h: [],
    index_h: 0,
    lastScrollTop: 0,
    scrollup: false,
    scrolldown: false,
    vh: $(window).height(),
    vw: $(window).width(),
    rod_h: $('.anim').height(),
    h: 0,
    context: Object,
    star: $("<div class='star'></div>"),
    arrPath: {},
    actual: 4,
    actualStep: 0,
    footstepSound: false,
    whooshSound: false,
    bellSound: false,
    windSound: false,
    dringSound: false,
    sounds: false,
    audioSteps: new Audio("assets/sounds/steps.mp3"),
    audioWhoosh: new Audio("assets/sounds/whoosh.mp3"),
    audioBell: new Audio("assets/sounds/bell.mp3"),
    audioWind: new Audio("assets/sounds/wind.mp3"),
    audioDring: new Audio("assets/sounds/dring.mp3"),
    getRandomInt: function(min, max) {
        return Math.random() * (max - min) + min;
    }
},
stars = {
    init: function(){
        rod.init()

        stars.buildStars(200, [
            {index:1, params:[0,40,0,100,1,3], blink: true},
            {index:2, params:[20,100,0,100,1,4], blink: true}
        ])
        stars.buildStars(50, [
            {index:0, params:[0,50,0,100,1,2.5], blink: false},
            {index:1, params:[0,50,0,100,2.5,4], blink: true},
            {index:2, params:[0,50,0,100,4,5], blink: true}
        ])
        
        onScroll.scrollTop()
    },
    buildStars: function(nb, rec){
        for (i = 0; i < rec.length; i++){
            for (j = 0; j < nb; j++) {
                let star = data.star.clone()

                $(".stars").append(
                    star
                    .addClass('star-'+rec[i].index)
                    .css({top: data.getRandomInt(rec[i].params[0], rec[i].params[1])+'%',
                        left: data.getRandomInt(rec[i].params[2], rec[i].params[3])+'%',
                        'animation-duration': data.getRandomInt(rec[i].params[4], rec[i].params[5])+'s'})
                    .toggleClass('blink', rec[i].blink )
                );
            }
        }
    }
},
rod = {
    init: function(){

        data.arrPath ={
            0: [
                274.076,705.071,250.009,744.985,228.9,833.742,206.742,872.687,186.548,908.18,152.052,887.634,150.109,918.922,148.411,946.271,132.813,954.725,192.179,925.544,256.645,903.233,234.047,906.222,269.704,888.171
            ],
            1: [
                311.861,692.631,277.321,681.05,252.508,674.304,225.307,634.948,202.089,601.355,211.419,557.149,171.865,575.937,149.749,586.442,138.725,654.324,201.013,697.281,258.107,728.428,262.075,733.39,313.269,738.418
            ],
            2: [
                311.861,692.631,265.473,605.198,320.838,548.044,326.823,531.102,338.473,498.122,450.808,486.834,487.253,576.576,518.198,652.774,280.138,416.529,288.597,530.355,288.668,596.694,348.677,688.364,406.093,739.453
            ],
            3:[
                242.9,656.6,294.6,719.5,339.782,502.005,345.767,485.063,357.417,452.083,396.968,432.465,493.428,441.26,619.139,452.722,638.726,672.441,452.333,588.234,289.708,543.406,17.087,340.855,-543.913,372.655
            ],
            4:[
                242.9,656.6,294.6,719.5,365.641,694.99,383.233,691.333,405.743,686.654,467.298,646.677,476.026,632.232,568.125,479.816,478.5,467.739,292.107,383.532,129.482,338.704,17.087,340.855,-543.913,372.655
            ],
            5: [
                242.9,656.6,294.6,719.5,379.817,776.782,394.8,786.7,411.382,797.677,420.945,797.752,433.7,786.7,587.98,653.023,726.9,449.2,691.5,261.5,528.875,216.672,363.6,211.6,202.6,243.4
            ]
        }

        rod.makePath(0, 0)
    },
    makePath: function(index, h){
        let thisPath = [],
            j = 0,
            step = 100

        for (var i = 0; i < data.arrPath[index].length; i++){
            let diff = Number(data.arrPath[index+1][i]) - Number(data.arrPath[index][i]),
                diffStep = diff / step,
                nb = Number(data.arrPath[index][i]) + diffStep * h

            thisPath.push(nb)
        }

        /* -------- white line vars --------- */

        $('#line').attr('x2', thisPath[0] + 0)
        $('#line').attr('y2', thisPath[1] + 0)

        for (item of thisPath){
            j++
            
            switch(j){
                case 1 : 
                    item = 'M' + item.toString()
                    break
                case 3 :
                case 9 :
                case 15 :
                case 21 :
                    item = 'C' + item.toString()
                    break
            }

            thisPath[j-1] = item
        }

        let defPath = thisPath.toString()
        $('#curvedline').find('.rod_line').attr('d', defPath.replaceAll(',', ' '))

        /* -------- big star vars --------- */
        let val = Number(Number(h - 150)/ 80)+1.625,
            dim = val * 75

        if(index == 4){
            $('.big_star').css({
                'transform' : 'matrix('+val+', 0, 0, '+val+', '+Number(thisPath[24] - dim)+', '+Number(thisPath[25] - dim)+')', 
                opacity : val})
        }
    }
},
onScroll = {
    countscroll: function(){

        /* -------- draw rod on scroll --------- */

        let h = $(this).scrollTop()*2 - 4000,
            h2 = $(this).scrollTop()*2,
            diff = h - data.lastScrollTop,
            this_h = data.rod_h/4,
            part = data.rod_h/10,
            percent = 100-Number(-Number(h - this_h)/this_h)*100,
            fact = 0, 
            dir = 1,
            nb = 0

        $('.scrollStar').css({top: Number(h2 * .33333 * data.vh/data.rod_h), 'transform' : 'rotate('+-Number(h2 * .33333 * data.vh/data.rod_h)+'deg)'})

        if (h2 < part){
            $('.step1').css({opacity: h2/part})
            $('.scroller').css({opacity: Number(1 - h2/part)})
        }

        if (h2 > part && h2 < 2*part){
            $('.step2').css({opacity: Number(1 - Number(h2 - part)/part)})
            $('.fisherman').css({opacity: 0})
            $('.scroller').css({opacity: 0})

            if(!data.footstepSound && data.sounds){
                data.footstepSound = true
                data.audioSteps.play()

                data.audioSteps.addEventListener("ended", (event) => {
                    console.log("Steps stopped")

                    data.footstepSound = false
                });
            }

            if(!data.windSound && data.sounds){
                data.windSound = true
                data.audioWind.play()

                data.audioWind.addEventListener("ended", (event) => {
                    console.log("Wind stopped")

                    data.windSound = false
                });
            }
        }

        if (h2 > 2*part && h2 < 2.5*part){
            $('.fisherman').css({opacity: Number(h2 - Number(2*part))/Number(.5*part)})
            $('.step1').css({opacity: 1})
            $('.step2').css({opacity: 0})
            $('.child, .title').css({opacity: 0})
            $('#line, .rod_line').css({opacity: 0})

            if(!data.dringSound && data.sounds){
                data.dringSound = true
                data.audioDring.play()

                data.audioDring.addEventListener("ended", (event) => {
                    console.log("Dring stopped")

                    data.dringSound = false
                });
            }
            
        }

        if (h2 > 2.5*part && h2 < 3*part){
            $('.fisherman').css({opacity: 1})
            $('.child').css({opacity: Number(h2 - Number(2.5*part))/Number(.5*part)})
            $('#line, .rod_line').css({opacity: 0})
        }

        if (h2 > 3*part && h2 < 3.5*part){
            $('.child').css({opacity: 1})
            $('#line, .rod_line').css({opacity: Number(h2 - Number(3*part))/Number(.5*part)})
        }

        if (h2 > 2.5*part && h2 < 5*part){
            $('.title').css({opacity: Number(h2 - Number(2.5*part))/Number(2.5*part)})
        }

        if (h2 > 3.5*part){
            $('#line, .rod_line').css({opacity: 1})
        }

        if (h2 > 4*part && h2 < 4.3*part){
            if(!data.whooshSound && data.sounds){
                data.whooshSound = true
                data.audioWhoosh.play()

                data.audioWhoosh.addEventListener("ended", (event) => {
                    console.log("Whoosh stopped")

                    data.whooshSound = false
                });
            }
        }

        if (h2 > 5.5*part && h2 < 5.8*part){
            if(!data.bellSound && data.sounds){
                data.bellSound = true
                data.audioBell.play()

                data.audioBell.addEventListener("ended", (event) => {
                    console.log("Bell stopped")

                    data.bellSound = false
                });
            }
        }

        if (h2 > 6.5*part && h2 < 8*part){
            $('.title').css({opacity: Number(1 - Number(h2 - Number(6.5*part))/Number(1.5*part))})
            $('.subtitle').css({opacity: 0})
        }

        if (h2 > 8.5*part && h2 < 10*part){
            $('.subtitle').css({opacity: Number(h2 - Number(8.5*part))/Number(1.5*part)})
            $('.title').css({opacity: 0})
        }

        if (h2 > 10.5*part && h2 < 13*part){
            $('.subtitle').css({opacity: Number(1 - Number(h2 - Number(10.5*part))/Number(2.5*part))})
            $('.leyers').css({opacity: 0})
        }

        if (h2 > 13*part && h2 < 17*part){
            $('.leyers').css({opacity: Number(h2 - Number(13*part))/Number(4*part)})
            let val = Number(1 - Number(h2 - Number(13*part))/Number(1.5*part)*38) + 38
            if (val < 0){val = 0}
            $('.leyers').find('.col-30').css({left: val+'vw'})
            $('.leyers').find('.col-70').css({right: val+'vw'})
            $('.subtitle').css({opacity: 0})

            let checked = $('#soundplayer').attr('checked'),
                vol = Number(1 - Number(h2 - Number(13*part))/Number(1.5*part))

            if (vol < 0){
                vol = 0
            }
            
            if (checked != undefined){
                data.audioWind.volume = vol
            }
        }

        if (h2 > 17*part && h2 < 18.5*part){
            $('.leyers').css({opacity: Number(1 - Number(h2 - Number(17*part))/Number(1.5*part))})
            $('.langs').css({opacity: 0})
        }

        if (h2 > 18.5*part && h2 < 20.5*part){
            $('.leyers').css({opacity: 0})
            $('.langs').css({opacity: Number(h2 - Number(18.5*part))/Number(2*part)})
        }

        if (h2 > 20.5*part && h2 < 22.5*part){
            
            $('.langs').css({opacity: Number(1 - Number(h2 - Number(20.5*part))/Number(2*part))})
            $('.logo').css({opacity: 0})
            $('.mentions').css({opacity: 0}).hide()
        }

        if (h2 > 22.5*part && h2 < 24.5*part){
            $('.langs').css({opacity: 0})
            $('.logo').css({opacity: Number(h2 - Number(22.5*part))/Number(2*part)})
        }

        if (h2 > 24.5*part && h2 < 26.5*part){
            $('.mentions').show()
            $('.mentions').css({opacity: Number(h2 - Number(24.5*part))/Number(2*part)})
        } 

        if (h2 > 27*part){
            $('.mentions').css({opacity: Number(1 - Number(h2 - Number(27*part))/Number(1*part))})
        }

        /* -------- rodline steps --------- */

        if (percent > 0 && percent <= 20){
            fact = 0
            nb = percent*5
        }

        if (percent > 20 && percent <= 40){
            fact = 1
            nb = percent*5 - 100
        }

        if (percent > 40 && percent <= 60){
            fact = 2
            nb = percent*5 - 200
        }

        if (percent > 60 && percent <= 80){
            fact = 3
            nb = percent*5 - 300
        }

        if (percent > 80 && percent <= 100){
            fact = 4
            nb = percent*5 - 400
        }

        if (percent > 100){
            fact = 4
            nb = 100
        }

        data.actual = fact

        rod.makePath(fact, nb)

        /* -------- scroll up vs scroll down --------- */

        if(h < data.lastScrollTop) {
            data.scrollup = true
            data.scrolldown = false

            dir = 1
        }
        else {
            data.scrollup = false
            data.scrolldown = true

            dir = -1
        }

        /* -------- actual section scrolled --------- */

        if (data.index_h >= 0 && data.index_h < data.tab_h.length){
            if(h > data.tab_h[data.index_h].h && data.scrolldown){
                data.index_h++
            }
        }

        if (data.index_h <= data.tab_h.length && data.index_h > 0){
            if(h < data.tab_h[data.index_h-1].h && data.scrollup){
                data.index_h--
            }
        }

        data.lastScrollTop = h
    },
    scrollTop: function(){
        window.scrollTo({ top: 0, behavior: 'smooth' });
        $('.content, header, footer, .scrollStar').delay(3000).animate({opacity: 1}, 1000, function(){
            $('body').css({'background-color' : '#0e3a56', 'overflow-y' : 'scroll', 'position' : 'relative', height : 'unset'})
            $('.sound_button').show()
        })
    }, 
    resize: function(){
        if (data.vw > 960){
            location.reload();
        }
    },
    load: function(){
        console.log('loaded')
        onScroll.scrollTop()
    }
},
sound = {
    playpause: function(e){
        e.stopPropagation();
        
        let checked = $(this).attr('checked')

        if (!checked){
            $(this).attr('checked', true)

            if(!data.sounds){
                data.sounds = true
            }

            data.audioSteps.volume = 1
            data.audioWhoosh.volume = 1
            data.audioBell.volume = 1
            data.audioWind.volume = 1
            data.audioDring.volume = 1

        } else {
            $(this).attr('checked', false)
            data.audioSteps.volume = 0
            data.audioWhoosh.volume = 0
            data.audioBell.volume = 0
            data.audioWind.volume = 0
            data.audioDring.volume = 0
        }
    } 
}

function multipress(keys, handler) {
    'use strict';

    if (keys.length === 0) {
        return;
    }

    var down = {};
    $(document).keydown(
        function (event) {
            down[event.keyCode] = true;
        }
    ).keyup(function (event) {
        // Copy keys array, build array of pressed keys
        var remaining = keys.slice(0),
            pressed = Object.keys(down).map(
                function (num) { 
                    return parseInt(num, 10); 
                }
            ),
            indexOfKey;
            // Remove pressedKeys from remainingKeys
            jQuery.each(pressed, function (i, key) {
                if (down[key] === true) { 
                    down[key] = false;
                    indexOfKey = remaining.indexOf(key);

                    if (indexOfKey > -1) {
                        remaining.splice(indexOfKey, 1);
                    }
                }
            });
            // If we hit all the keys, fire off handler
            if (remaining.length === 0) {
                handler(event);
            }
        }
    );
};

multipress(
    [78, 80], 
    function () {

        let nIntervId = setInterval(swapImages,500);

        function swapImages(){
            $('.pn').toggleClass('pn2').toggleClass('pn1')
        }

        console.log('multipress')
        $('.pn').animate({left : data.vw}, 10000, function(){
            $(this).css({left : -350})
            clearInterval(nIntervId)
        })

        
    }
);

$('#soundplayer').on('click', sound.playpause)
$(document).on('scroll', onScroll.countscroll)
document.addEventListener('DOMContentLoaded', stars.init)
window.addEventListener('resize', onScroll.resize)
window.addEventListener('load', onScroll.load)
